/*!
 Based on ndef.parser, by Raphael Graf(r@undefined.ch)
 http://www.undefined.ch/mparser/index.html

 Ported to JavaScript and modified by Matthew Crumley (email@matthewcrumley.com, http://silentmatt.com/)

 You are free to use and modify this code in anyway you find useful. Please leave this comment in the code
 to acknowledge its original source. If you feel like it, I enjoy hearing about projects that use my code,
 but don't feel like you have to let me know or ask permission.
*/
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):t.exprEval=e()}(this,function(){"use strict";var t="INUMBER",e="IOP1",s="IOP2",r="IOP3",n="IVAR",i="IFUNCALL",o="IEXPR",a="IMEMBER";function h(t,e){this.type=t,this.value=null!=e?e:0}function p(t){return new h(e,t)}function u(t){return new h(s,t)}function c(t){return new h(r,t)}function l(h,p){for(var u,c,v,x,y=[],w=0;w<h.length;w++){var d=h[w],g=d.type;if(g===t)"number"==typeof d.value&&d.value<0?y.push("("+d.value+")"):y.push(f(d.value));else if(g===s)c=y.pop(),u=y.pop(),x=d.value,p?"^"===x?y.push("Math.pow("+u+", "+c+")"):"and"===x?y.push("(!!"+u+" && !!"+c+")"):"or"===x?y.push("(!!"+u+" || !!"+c+")"):"||"===x?y.push("(String("+u+") + String("+c+"))"):"=="===x?y.push("("+u+" === "+c+")"):"!="===x?y.push("("+u+" !== "+c+")"):y.push("("+u+" "+x+" "+c+")"):y.push("("+u+" "+x+" "+c+")");else if(g===r){if(v=y.pop(),c=y.pop(),u=y.pop(),"?"!==(x=d.value))throw new Error("invalid Expression");y.push("("+u+" ? "+c+" : "+v+")")}else if(g===n)y.push(d.value);else if(g===e)u=y.pop(),"-"===(x=d.value)||"+"===x?y.push("("+x+u+")"):p?"not"===x?y.push("(!"+u+")"):"!"===x?y.push("fac("+u+")"):y.push(x+"("+u+")"):"!"===x?y.push("("+u+"!)"):y.push("("+x+" "+u+")");else if(g===i){for(var M=d.value,k=[];M-- >0;)k.unshift(y.pop());x=y.pop(),y.push(x+"("+k.join(", ")+")")}else if(g===a)u=y.pop(),y.push(u+"."+d.value);else{if(g!==o)throw new Error("invalid Expression");y.push("("+l(d.value,p)+")")}}if(y.length>1)throw new Error("invalid Expression (parity)");return String(y[0])}function f(t){return"string"==typeof t?JSON.stringify(t).replace(/\u2028/g,"\\u2028").replace(/\u2029/g,"\\u2029"):t}function v(t,e){for(var s=0;s<t.length;s++)if(t[s]===e)return!0;return!1}function x(t,e,s){for(var r=!!(s=s||{}).withMembers,i=null,h=0;h<t.length;h++){var p=t[h];p.type!==n||v(e,p.value)?p.type===a&&r&&null!==i?i+="."+p.value:p.type===o?x(p.value,e,s):null!==i&&(v(e,i)||e.push(i),i=null):r?null!==i?(v(e,i)||e.push(i),i=p.value):i=p.value:e.push(p.value)}null===i||v(e,i)||e.push(i)}function y(t,e){this.tokens=t,this.parser=e,this.unaryOps=e.unaryOps,this.binaryOps=e.binaryOps,this.ternaryOps=e.ternaryOps,this.functions=e.functions}h.prototype.toString=function(){switch(this.type){case t:case e:case s:case r:case n:return this.value;case i:return"CALL "+this.value;case a:return"."+this.value;default:return"Invalid Instruction"}},y.prototype.simplify=function(i){return i=i||{},new y(function i(p,u,c,l,f){for(var v,x,y,w,d=[],g=[],M=0;M<p.length;M++){var k=p[M],b=k.type;if(b===t)d.push(k);else if(b===n&&f.hasOwnProperty(k.value))k=new h(t,f[k.value]),d.push(k);else if(b===s&&d.length>1)x=d.pop(),v=d.pop(),w=c[k.value],k=new h(t,w(v.value,x.value)),d.push(k);else if(b===r&&d.length>2)y=d.pop(),x=d.pop(),v=d.pop(),"?"===k.value?d.push(v.value?x.value:y.value):(w=l[k.value],k=new h(t,w(v.value,x.value,y.value)),d.push(k));else if(b===e&&d.length>0)v=d.pop(),w=u[k.value],k=new h(t,w(v.value)),d.push(k);else if(b===o){for(;d.length>0;)g.push(d.shift());g.push(new h(o,i(k.value,u,c,l,f)))}else if(b===a&&d.length>0)v=d.pop(),d.push(new h(t,v.value[k.value]));else{for(;d.length>0;)g.push(d.shift());g.push(k)}}for(;d.length>0;)g.push(d.shift());return g}(this.tokens,this.unaryOps,this.binaryOps,this.ternaryOps,i),this.parser)},y.prototype.substitute=function(t,i){return i instanceof y||(i=this.parser.parse(String(i))),new y(function t(i,a,l){for(var f=[],v=0;v<i.length;v++){var x=i[v],y=x.type;if(y===n&&x.value===a)for(var w=0;w<l.tokens.length;w++){var d,g=l.tokens[w];d=g.type===e?p(g.value):g.type===s?u(g.value):g.type===r?c(g.value):new h(g.type,g.value),f.push(d)}else y===o?f.push(new h(o,t(x.value,a,l))):f.push(x)}return f}(this.tokens,t,i),this.parser)},y.prototype.evaluate=function(h){return h=h||{},function h(p,u,c){for(var l,f,v,x,y=[],w=0;w<p.length;w++){var d=p[w],g=d.type;if(g===t)y.push(d.value);else if(g===s)f=y.pop(),l=y.pop(),x=u.binaryOps[d.value],y.push(x(l,f));else if(g===r)v=y.pop(),f=y.pop(),l=y.pop(),"?"===d.value?y.push(h(l?f:v,u,c)):(x=u.ternaryOps[d.value],y.push(x(l,f,v)));else if(g===n)if(d.value in u.functions)y.push(u.functions[d.value]);else{var M=c[d.value];if(void 0===M)throw new Error("undefined variable: "+d.value);y.push(M)}else if(g===e)l=y.pop(),x=u.unaryOps[d.value],y.push(x(l));else if(g===i){for(var k=d.value,b=[];k-- >0;)b.unshift(y.pop());if(!(x=y.pop()).apply||!x.call)throw new Error(x+" is not a function");y.push(x.apply(void 0,b))}else if(g===o)y.push(d.value);else{if(g!==a)throw new Error("invalid Expression");l=y.pop(),y.push(l[d.value])}}if(y.length>1)throw new Error("invalid Expression (parity)");return y[0]}(this.tokens,this,h)},y.prototype.toString=function(){return l(this.tokens,!1)},y.prototype.symbols=function(t){t=t||{};var e=[];return x(this.tokens,e,t),e},y.prototype.variables=function(t){t=t||{};var e=[];x(this.tokens,e,t);var s=this.functions;return e.filter(function(t){return!(t in s)})},y.prototype.toJSFunction=function(t,e){var s=this,r=new Function(t,"with(this.functions) with (this.ternaryOps) with (this.binaryOps) with (this.unaryOps) { return "+l(this.simplify(e).tokens,!0)+"; }");return function(){return r.apply(s,arguments)}};var w="TEOF",d="TOP",g="TNUMBER",M="TSTRING",k="TPAREN",b="TCOMMA",m="TNAME";function E(t,e,s){this.type=t,this.value=e,this.index=s}function O(t,e){this.pos=0,this.current=null,this.unaryOps=t.unaryOps,this.binaryOps=t.binaryOps,this.ternaryOps=t.ternaryOps,this.consts=t.consts,this.expression=e,this.savedPosition=0,this.savedCurrent=null,this.options=t.options}E.prototype.toString=function(){return this.type+": "+this.value},O.prototype.newToken=function(t,e,s){return new E(t,e,null!=s?s:this.pos)},O.prototype.save=function(){this.savedPosition=this.pos,this.savedCurrent=this.current},O.prototype.restore=function(){this.pos=this.savedPosition,this.current=this.savedCurrent},O.prototype.next=function(){return this.pos>=this.expression.length?this.newToken(w,"EOF"):this.isWhitespace()||this.isComment()?this.next():this.isRadixInteger()||this.isNumber()||this.isOperator()||this.isString()||this.isParen()||this.isComma()||this.isNamedOp()||this.isConst()||this.isName()?this.current:void this.parseError('Unknown character "'+this.expression.charAt(this.pos)+'"')},O.prototype.isString=function(){var t=!1,e=this.pos,s=this.expression.charAt(e);if("'"===s||'"'===s)for(var r=this.expression.indexOf(s,e+1);r>=0&&this.pos<this.expression.length;){if(this.pos=r+1,"\\"!==this.expression.charAt(r-1)){var n=this.expression.substring(e+1,r);this.current=this.newToken(M,this.unescape(n),e),t=!0;break}r=this.expression.indexOf(s,r+1)}return t},O.prototype.isParen=function(){var t=this.expression.charAt(this.pos);return("("===t||")"===t)&&(this.current=this.newToken(k,t),this.pos++,!0)},O.prototype.isComma=function(){return","===this.expression.charAt(this.pos)&&(this.current=this.newToken(b,","),this.pos++,!0)},O.prototype.isConst=function(){for(var t=this.pos,e=t;e<this.expression.length;e++){var s=this.expression.charAt(e);if(s.toUpperCase()===s.toLowerCase()&&(e===this.pos||"_"!==s&&"."!==s&&(s<"0"||s>"9")))break}if(e>t){var r=this.expression.substring(t,e);if(r in this.consts)return this.current=this.newToken(g,this.consts[r]),this.pos+=r.length,!0}return!1},O.prototype.isNamedOp=function(){for(var t=this.pos,e=t;e<this.expression.length;e++){var s=this.expression.charAt(e);if(s.toUpperCase()===s.toLowerCase()&&(e===this.pos||"_"!==s&&(s<"0"||s>"9")))break}if(e>t){var r=this.expression.substring(t,e);if(this.isOperatorEnabled(r)&&(r in this.binaryOps||r in this.unaryOps||r in this.ternaryOps))return this.current=this.newToken(d,r),this.pos+=r.length,!0}return!1},O.prototype.isName=function(){for(var t=this.pos,e=t,s=!1;e<this.expression.length;e++){var r=this.expression.charAt(e);if(r.toUpperCase()===r.toLowerCase()){if(e===this.pos&&"$"===r)continue;if(e===this.pos||!s||"_"!==r&&(r<"0"||r>"9"))break}else s=!0}if(s){var n=this.expression.substring(t,e);return this.current=this.newToken(m,n),this.pos+=n.length,!0}return!1},O.prototype.isWhitespace=function(){for(var t=!1,e=this.expression.charAt(this.pos);!(" "!==e&&"\t"!==e&&"\n"!==e&&"\r"!==e||(t=!0,this.pos++,this.pos>=this.expression.length));)e=this.expression.charAt(this.pos);return t};var A=/^[0-9a-f]{4}$/i;O.prototype.unescape=function(t){var e=t.indexOf("\\");if(e<0)return t;for(var s=t.substring(0,e);e>=0;){var r=t.charAt(++e);switch(r){case"'":s+="'";break;case'"':s+='"';break;case"\\":s+="\\";break;case"/":s+="/";break;case"b":s+="\b";break;case"f":s+="\f";break;case"n":s+="\n";break;case"r":s+="\r";break;case"t":s+="\t";break;case"u":var n=t.substring(e+1,e+5);A.test(n)||this.parseError("Illegal escape sequence: \\u"+n),s+=String.fromCharCode(parseInt(n,16)),e+=4;break;default:throw this.parseError('Illegal escape sequence: "\\'+r+'"')}++e;var i=t.indexOf("\\",e);s+=t.substring(e,i<0?t.length:i),e=i}return s},O.prototype.isComment=function(){return"/"===this.expression.charAt(this.pos)&&"*"===this.expression.charAt(this.pos+1)&&(this.pos=this.expression.indexOf("*/",this.pos)+2,1===this.pos&&(this.pos=this.expression.length),!0)},O.prototype.isRadixInteger=function(){var t,e,s=this.pos;if(s>=this.expression.length-2||"0"!==this.expression.charAt(s))return!1;if(++s,"x"===this.expression.charAt(s))t=16,e=/^[0-9a-f]$/i,++s;else{if("b"!==this.expression.charAt(s))return!1;t=2,e=/^[01]$/i,++s}for(var r=!1,n=s;s<this.expression.length;){var i=this.expression.charAt(s);if(!e.test(i))break;s++,r=!0}return r&&(this.current=this.newToken(g,parseInt(this.expression.substring(n,s),t)),this.pos=s),r},O.prototype.isNumber=function(){for(var t,e=!1,s=this.pos,r=s,n=s,i=!1,o=!1;s<this.expression.length&&((t=this.expression.charAt(s))>="0"&&t<="9"||!i&&"."===t);)"."===t?i=!0:o=!0,s++,e=o;if(e&&(n=s),"e"===t||"E"===t){s++;for(var a=!0,h=!1;s<this.expression.length;){if(t=this.expression.charAt(s),!a||"+"!==t&&"-"!==t){if(!(t>="0"&&t<="9"))break;h=!0,a=!1}else a=!1;s++}h||(s=n)}return e?(this.current=this.newToken(g,parseFloat(this.expression.substring(r,s))),this.pos=s):this.pos=n,e},O.prototype.isOperator=function(){var t=this.pos,e=this.expression.charAt(this.pos);if("+"===e||"-"===e||"*"===e||"/"===e||"%"===e||"^"===e||"?"===e||":"===e||"."===e)this.current=this.newToken(d,e);else if("∙"===e||"•"===e)this.current=this.newToken(d,"*");else if(">"===e)"="===this.expression.charAt(this.pos+1)?(this.current=this.newToken(d,">="),this.pos++):this.current=this.newToken(d,">");else if("<"===e)"="===this.expression.charAt(this.pos+1)?(this.current=this.newToken(d,"<="),this.pos++):this.current=this.newToken(d,"<");else if("|"===e){if("|"!==this.expression.charAt(this.pos+1))return!1;this.current=this.newToken(d,"||"),this.pos++}else if("="===e){if("="!==this.expression.charAt(this.pos+1))return!1;this.current=this.newToken(d,"=="),this.pos++}else{if("!"!==e)return!1;"="===this.expression.charAt(this.pos+1)?(this.current=this.newToken(d,"!="),this.pos++):this.current=this.newToken(d,e)}return this.pos++,!!this.isOperatorEnabled(this.current.value)||(this.pos=t,!1)};var T={"+":"add","-":"subtract","*":"multiply","/":"divide","%":"remainder","^":"power","!":"factorial","<":"comparison",">":"comparison","<=":"comparison",">=":"comparison","==":"comparison","!=":"comparison","||":"concatenate",and:"logical",or:"logical",not:"logical","?":"conditional",":":"conditional"};function C(t,e,s){this.parser=t,this.tokens=e,this.current=null,this.nextToken=null,this.next(),this.savedCurrent=null,this.savedNextToken=null,this.allowMemberAccess=!1!==s.allowMemberAccess}O.prototype.isOperatorEnabled=function(t){var e,s=(e=t,T.hasOwnProperty(e)?T[e]:e),r=this.options.operators||{};return"in"===s?!!r.in:!(s in r&&!r[s])},O.prototype.getCoordinates=function(){var t,e=0,s=-1;do{e++,t=this.pos-s,s=this.expression.indexOf("\n",s+1)}while(s>=0&&s<this.pos);return{line:e,column:t}},O.prototype.parseError=function(t){var e=this.getCoordinates();throw new Error("parse error ["+e.line+":"+e.column+"]: "+t)},C.prototype.next=function(){return this.current=this.nextToken,this.nextToken=this.tokens.next()},C.prototype.tokenMatches=function(t,e){return void 0===e||(Array.isArray(e)?v(e,t.value):"function"==typeof e?e(t):t.value===e)},C.prototype.save=function(){this.savedCurrent=this.current,this.savedNextToken=this.nextToken,this.tokens.save()},C.prototype.restore=function(){this.tokens.restore(),this.current=this.savedCurrent,this.nextToken=this.savedNextToken},C.prototype.accept=function(t,e){return!(this.nextToken.type!==t||!this.tokenMatches(this.nextToken,e))&&(this.next(),!0)},C.prototype.expect=function(t,e){if(!this.accept(t,e)){var s=this.tokens.getCoordinates();throw new Error("parse error ["+s.line+":"+s.column+"]: Expected "+(e||t))}},C.prototype.parseAtom=function(e){if(this.accept(m))e.push(new h(n,this.current.value));else if(this.accept(g))e.push(new h(t,this.current.value));else if(this.accept(M))e.push(new h(t,this.current.value));else{if(!this.accept(k,"("))throw new Error("unexpected "+this.nextToken);this.parseExpression(e),this.expect(k,")")}},C.prototype.parseExpression=function(t){this.parseConditionalExpression(t)},C.prototype.parseConditionalExpression=function(t){for(this.parseOrExpression(t);this.accept(d,"?");){var e=[],s=[];this.parseConditionalExpression(e),this.expect(d,":"),this.parseConditionalExpression(s),t.push(new h(o,e)),t.push(new h(o,s)),t.push(c("?"))}},C.prototype.parseOrExpression=function(t){for(this.parseAndExpression(t);this.accept(d,"or");)this.parseAndExpression(t),t.push(u("or"))},C.prototype.parseAndExpression=function(t){for(this.parseComparison(t);this.accept(d,"and");)this.parseComparison(t),t.push(u("and"))};var N=["==","!=","<","<=",">=",">","in"];C.prototype.parseComparison=function(t){for(this.parseAddSub(t);this.accept(d,N);){var e=this.current;this.parseAddSub(t),t.push(u(e.value))}};var I=["+","-","||"];C.prototype.parseAddSub=function(t){for(this.parseTerm(t);this.accept(d,I);){var e=this.current;this.parseTerm(t),t.push(u(e.value))}};var P=["*","/","%"];function S(t,e){return Number(t)+Number(e)}function F(t,e){return t-e}function L(t,e){return t*e}function q(t,e){return t/e}function R(t,e){return t%e}function U(t,e){return""+t+e}function B(t,e){return t===e}function $(t,e){return t!==e}function _(t,e){return t>e}function j(t,e){return t<e}function G(t,e){return t>=e}function J(t,e){return t<=e}function W(t,e){return Boolean(t&&e)}function V(t,e){return Boolean(t||e)}function X(t,e){return v(e,t)}function z(t){return(Math.exp(t)-Math.exp(-t))/2}function D(t){return(Math.exp(t)+Math.exp(-t))/2}function H(t){return t===1/0?1:t===-1/0?-1:(Math.exp(t)-Math.exp(-t))/(Math.exp(t)+Math.exp(-t))}function K(t){return t===-1/0?t:Math.log(t+Math.sqrt(t*t+1))}function Q(t){return Math.log(t+Math.sqrt(t*t-1))}function Y(t){return Math.log((1+t)/(1-t))/2}function Z(t){return Math.log(t)*Math.LOG10E}function tt(t){return-t}function et(t){return!t}function st(t){return t<0?Math.ceil(t):Math.floor(t)}function rt(t){return Math.random()*(t||1)}function nt(t){return at(t+1)}C.prototype.parseTerm=function(t){for(this.parseFactor(t);this.accept(d,P);){var e=this.current;this.parseFactor(t),t.push(u(e.value))}},C.prototype.parseFactor=function(t){var e=this.tokens.unaryOps;if(this.save(),this.accept(d,function(t){return t.value in e}))if("-"!==this.current.value&&"+"!==this.current.value&&this.nextToken.type===k&&"("===this.nextToken.value)this.restore(),this.parseExponential(t);else{var s=this.current;this.parseFactor(t),t.push(p(s.value))}else this.parseExponential(t)},C.prototype.parseExponential=function(t){for(this.parsePostfixExpression(t);this.accept(d,"^");)this.parseFactor(t),t.push(u("^"))},C.prototype.parsePostfixExpression=function(t){for(this.parseFunctionCall(t);this.accept(d,"!");)t.push(p("!"))},C.prototype.parseFunctionCall=function(t){var e=this.tokens.unaryOps;if(this.accept(d,function(t){return t.value in e})){var s=this.current;this.parseAtom(t),t.push(p(s.value))}else for(this.parseMemberExpression(t);this.accept(k,"(");)if(this.accept(k,")"))t.push(new h(i,0));else{var r=this.parseArgumentList(t);t.push(new h(i,r))}},C.prototype.parseArgumentList=function(t){for(var e=0;!this.accept(k,")");)for(this.parseExpression(t),++e;this.accept(b);)this.parseExpression(t),++e;return e},C.prototype.parseMemberExpression=function(t){for(this.parseAtom(t);this.accept(d,".");){if(!this.allowMemberAccess)throw new Error('unexpected ".", member access is not permitted');this.expect(m),t.push(new h(a,this.current.value))}};var it=4.7421875,ot=[.9999999999999971,57.15623566586292,-59.59796035547549,14.136097974741746,-.4919138160976202,3399464998481189e-20,4652362892704858e-20,-9837447530487956e-20,.0001580887032249125,-.00021026444172410488,.00021743961811521265,-.0001643181065367639,8441822398385275e-20,-26190838401581408e-21,36899182659531625e-22];function at(t){var e,s,r;if(r=t,isFinite(r)&&r===Math.round(r)){if(t<=0)return isFinite(t)?1/0:NaN;if(t>171)return 1/0;for(var n=t-2,i=t-1;n>1;)i*=n,n--;return 0===i&&(i=1),i}if(t<.5)return Math.PI/(Math.sin(Math.PI*t)*at(1-t));if(t>=171.35)return 1/0;if(t>85){var o=t*t,a=o*t,h=a*t,p=h*t;return Math.sqrt(2*Math.PI/t)*Math.pow(t/Math.E,t)*(1+1/(12*t)+1/(288*o)-139/(51840*a)-571/(2488320*h)+163879/(209018880*p)+5246819/(75246796800*p*t))}--t,s=ot[0];for(var u=1;u<ot.length;++u)s+=ot[u]/(t+u);return e=t+it+.5,Math.sqrt(2*Math.PI)*Math.pow(e,t+.5)*Math.exp(-e)*s}function ht(t){return String(t).length}function pt(){for(var t=0,e=0,s=0;s<arguments.length;s++){var r,n=Math.abs(arguments[s]);e<n?(t=t*(r=e/n)*r+1,e=n):t+=n>0?(r=n/e)*r:n}return e===1/0?1/0:e*Math.sqrt(t)}function ut(t,e,s){return t?e:s}function ct(t,e){return void 0===e||0==+e?Math.round(t):(t=+t,e=-+e,isNaN(t)||"number"!=typeof e||e%1!=0?NaN:(t=t.toString().split("e"),+((t=(t=Math.round(+(t[0]+"e"+(t[1]?+t[1]-e:-e)))).toString().split("e"))[0]+"e"+(t[1]?+t[1]+e:e))))}function lt(t){this.options=t||{},this.unaryOps={sin:Math.sin,cos:Math.cos,tan:Math.tan,asin:Math.asin,acos:Math.acos,atan:Math.atan,sinh:Math.sinh||z,cosh:Math.cosh||D,tanh:Math.tanh||H,asinh:Math.asinh||K,acosh:Math.acosh||Q,atanh:Math.atanh||Y,sqrt:Math.sqrt,log:Math.log,ln:Math.log,lg:Math.log10||Z,log10:Math.log10||Z,abs:Math.abs,ceil:Math.ceil,floor:Math.floor,round:Math.round,trunc:Math.trunc||st,"-":tt,"+":Number,exp:Math.exp,not:et,length:ht,"!":nt},this.binaryOps={"+":S,"-":F,"*":L,"/":q,"%":R,"^":Math.pow,"||":U,"==":B,"!=":$,">":_,"<":j,">=":G,"<=":J,and:W,or:V,in:X},this.ternaryOps={"?":ut},this.functions={random:rt,fac:nt,min:Math.min,max:Math.max,hypot:Math.hypot||pt,pyt:Math.hypot||pt,pow:Math.pow,atan2:Math.atan2,if:ut,gamma:at,roundTo:ct},this.consts={E:Math.E,PI:Math.PI,true:!0,false:!1}}lt.prototype.parse=function(t){var e=[],s=new C(this,new O(this,t),{allowMemberAccess:this.options.allowMemberAccess});return s.parseExpression(e),s.expect(w,"EOF"),new y(e,this)},lt.prototype.evaluate=function(t,e){return this.parse(t).evaluate(e)};var ft=new lt;return lt.parse=function(t){return ft.parse(t)},lt.evaluate=function(t,e){return ft.parse(t).evaluate(e)},{Parser:lt,Expression:y}});